/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.led;

import com.ibm.hsc.auiml.databeans.led.LEDInfoState;
import com.ibm.hsc.auiml.databeans.led.SwitchObjectInfo;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HardwareServiceFunctions
extends MObjectImpl {
    private static final String TRACE_MASKD = "JHSFNCTD";
    private static final String TRACE_MASKF = "JHSFNCTF";
    private static final String TRACE_MASKT = "JHSFNCTT";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 120, "HWServFnct");
    private static final short ERRID_0020 = 32;
    private static final short ERRID_0021 = 33;
    private static final short ERRID_0022 = 34;
    private static final short ERRID_0023 = 35;
    private static final short ERRID_0024 = 36;
    private static final short ERRID_0025 = 37;
    private static final short ERRID_0026 = 38;
    public static final String LED_STATE_ON = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "LED_STATE_ON", "on");
    public static final String LED_STATE_OFF = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "LED_STATE_OFF", "off");
    public static final String LED_STATE_UNSUPPORTED = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "LED_STATE_UNSUPPORTED", "unsupported");
    public static final int LOCATION_CODE_INDEX = 0;
    public static final int STATE_INDEX = 1;
    public static final String I_STUB_CMD = "/opt/hsc/bin/i_stub_FS";
    public static final String VPDFS_CMD = "/opt/hsc/bin/vpdfs";

    public HardwareServiceFunctions(String string) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.c-tor()");
        this.setKey(string);
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.c-tor()");
    }

    public static String getClassName() {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.getClassName()");
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.getClassName()");
        return HSCResourceBundleUtil.getMessage("SFPResourceBundle", "HARDWARE_SERVICE_FUNCTIONS", "Hardware Service Functions");
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.getInstance()");
        String string = mOXReference.getKey();
        HardwareServiceFunctions hardwareServiceFunctions = new HardwareServiceFunctions(string);
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.getInstance()");
        return hardwareServiceFunctions;
    }

    public static Vector FetchCECList() throws Throwable {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = null;
        CECInfo cECInfo = null;
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchCECList()");
        try {
            Enumeration enumeration;
            vector2 = CIMUtils.getCECsInfo();
            if (vector2 != null && vector2.size() > 0) {
                Trace.trace(TRACE_MASKF, "tempVector size is " + vector2.size());
            } else {
                Trace.trace(TRACE_MASKF, "getCECsInfo() returned a vector of size 0, or vector is null");
            }
            if (vector2 != null && vector2.size() > 0) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    cECInfo = (CECInfo)enumeration.nextElement();
                    Trace.trace(TRACE_MASKF, "model type is " + cECInfo.getCECModelType());
                    Trace.trace(TRACE_MASKF, "serial nunmber is " + cECInfo.getCECSerialNumber());
                    Trace.trace(TRACE_MASKF, "machine name is " + cECInfo.getCECMachineName());
                    vector.addElement(cECInfo.getCECModelType() + "*" + cECInfo.getCECSerialNumber() + "." + cECInfo.getCECMachineName());
                }
            }
            if (vector != null) {
                Trace.trace(TRACE_MASKD, "getCECsInfo() found the following CECs:");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Trace.trace(TRACE_MASKD, "CEC found of " + (String)enumeration.nextElement());
                }
            } else {
                Trace.trace(TRACE_MASKD, "getCECsInfo returned null");
            }
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "-- HardwareServiceFunctions.FetchCECList() exception is " + throwable);
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchCECList()");
        return vector;
    }

    public static String FetchSysAttnLEDState(String string) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchSysAttnLedState()");
        String string2 = LED_STATE_UNSUPPORTED;
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            String string3 = InetAddress.getLocalHost().getHostName();
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string3, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            if (hSCCECClient.isSystemAttentionSupported()) {
                Trace.trace(TRACE_MASKF, "-- SysAttn LED is supported, continuing...");
                Hashtable hashtable = hSCCECClient.getSystemAttentionList();
                Trace.trace(TRACE_MASKD, "-- attnList hashtable retrieved, continuing...");
                if (hashtable != null && hashtable.size() != 0) {
                    Trace.trace(TRACE_MASKF, "-- attnList is not null or 0");
                    Vector vector = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    if (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        Trace.trace(TRACE_MASKD, "-- keyID is <" + string4 + ">");
                        vector = (Vector)hashtable.get(string4);
                        short s = (Short)vector.elementAt(1);
                        string2 = 1 == s ? LED_STATE_ON : LED_STATE_OFF;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- attnList is null or attnList.size() == 0");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- System Attention is not supported for this MTMS, <" + string + ">");
            }
        }
        catch (HSCException hSCException) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchSysAttnLedState() internal exception: " + hSCException);
            new AusMicrocodeLog(_logInfo, 32, hSCException).writeEntry(null);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchSysAttnLedState() general exception: " + throwable);
            new AusMicrocodeLog(_logInfo, 37, throwable).writeEntry(null);
        }
        Trace.trace(TRACE_MASKF, "-- return state is <" + string2 + ">");
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchSysAttnLedState()");
        return string2;
    }

    public static Vector FetchFRUIdentifyList(String string) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchFRUIdentifyList()");
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<Short> vector3 = new Vector<Short>();
        Vector<Long> vector4 = new Vector<Long>();
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            if (hSCCECClient.isIdentifySupported()) {
                Trace.trace(TRACE_MASKF, "-- Identify LED is supported, continuing...");
                Hashtable hashtable = hSCCECClient.getIdentifyList();
                Trace.trace(TRACE_MASKD, "-- identifyList hashtable retrieved, continuing...");
                if (hashtable != null && hashtable.size() != 0) {
                    Trace.trace(TRACE_MASKF, "-- identifyList is not null or 0");
                    Vector vector5 = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        Trace.trace(TRACE_MASKD, "-- keyID is <" + string3 + ">");
                        vector5 = (Vector)hashtable.get(string3);
                        String string4 = (String)vector5.elementAt(0);
                        Short s = (Short)vector5.elementAt(1);
                        Long l = new Long(string3);
                        Trace.trace(TRACE_MASKF, "-- locCode is <" + string4 + ">, state is <" + s + ">, slot index is <" + l + ">");
                        vector2.addElement(string4);
                        vector3.addElement(s);
                        vector4.addElement(l);
                    }
                    vector.addElement(vector2);
                    vector.addElement(vector3);
                    vector.addElement(vector4);
                } else {
                    Trace.trace(TRACE_MASKF, "-- identifyList is null or identifyList.size() = 0");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- Identify is not supported for this MTMS, <" + string + ">");
            }
        }
        catch (HSCException hSCException) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchFRUIdentifyList() internal exception: " + hSCException);
            new AusMicrocodeLog(_logInfo, 33, hSCException).writeEntry(null);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchFRUIdentifyList() general exception: " + throwable);
            new AusMicrocodeLog(_logInfo, 37, throwable).writeEntry(null);
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchFRUIdentifyList()");
        return vector;
    }

    public static Vector FetchFRUIdentifyLEDState(String string, Vector vector) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchFRUIdentifyLEDState()");
        Vector<String> vector2 = new Vector<String>();
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            if (hSCCECClient.isIdentifySupported()) {
                Trace.trace(TRACE_MASKF, "-- Identify LED is supported, continuing...");
                int n = 0;
                while (n < vector.size()) {
                    Integer n2 = (Integer)vector.elementAt(n);
                    long l = n2.longValue();
                    short s = hSCCECClient.getIdentifyState(l);
                    Trace.trace(TRACE_MASKF, "-- slot <" + l + ">, Identify LED state set to <" + s + ">");
                    if (1 == s) {
                        vector2.addElement(LED_STATE_ON);
                    } else {
                        vector2.addElement(LED_STATE_OFF);
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < vector.size()) {
                    vector2.addElement(LED_STATE_UNSUPPORTED);
                    ++n;
                }
            }
        }
        catch (HSCException hSCException) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchFRUIdentifyLEDState() internal exception: " + hSCException);
            new AusMicrocodeLog(_logInfo, 34, hSCException).writeEntry(null);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchFRUIdentifyLEDState() general exception: " + throwable);
            new AusMicrocodeLog(_logInfo, 37, throwable).writeEntry(null);
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchFRUIdentifyLEDState()");
        return vector2;
    }

    public static String SetSystemAttnState(LEDInfoState lEDInfoState) throws Exception {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.SetSystemAttnState()");
        Integer n = lEDInfoState.getState();
        String string = lEDInfoState.getMTMS();
        Short s = new Short(n.toString());
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            if (hSCCECClient.isSystemAttentionSupported()) {
                Trace.trace(TRACE_MASKF, "-- SysAttn LED is supported, continuing...");
                Hashtable hashtable = hSCCECClient.getSystemAttentionList();
                Trace.trace(TRACE_MASKD, "-- attnList hashtable retrieved, continuing...");
                if (hashtable != null && hashtable.size() != 0) {
                    Trace.trace(TRACE_MASKF, "-- attnList is not null or 0");
                    Vector<Long> vector = new Vector<Long>();
                    Vector<Short> vector2 = new Vector<Short>();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        Trace.trace(TRACE_MASKD, "-- attnList key found, <" + string3 + ">");
                        Long l = new Long(string3);
                        vector.addElement(l);
                        vector2.addElement(s);
                    }
                    if (vector.size() > 0) {
                        hSCCECClient.setSystemAttentionState(vector, vector2);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- attnList is null or attnList.size() == 0");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- System Attention is not supported for this MTMS, <" + string + ">");
            }
        }
        catch (HSCException hSCException) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetSystemAttnState() internal exception: " + hSCException);
            new AusMicrocodeLog(_logInfo, 35, hSCException).writeEntry(null);
            throw new Exception("SysAttn");
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetSystemAttnState() general exception: " + throwable);
            new AusMicrocodeLog(_logInfo, 37, throwable).writeEntry(null);
            throw new Exception("SysAttn");
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.SetSystemAttnState()");
        return "SysAttn";
    }

    public static String SetIdentifyLEDState(LEDInfoState lEDInfoState) throws Exception {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.SetIdentifyLEDState()");
        Integer n = lEDInfoState.getState();
        String string = lEDInfoState.getMTMS();
        Vector vector = lEDInfoState.getLocCodes();
        Short s = new Short(n.toString());
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            if (hSCCECClient.isIdentifySupported()) {
                Trace.trace(TRACE_MASKF, "-- Identify LED is supported, continuing...");
                Hashtable hashtable = hSCCECClient.getIdentifyList();
                Trace.trace(TRACE_MASKD, "-- identifyList hashtable retrieved, continuing...");
                if (hashtable != null && hashtable.size() != 0) {
                    Trace.trace(TRACE_MASKF, "-- identifyList is not null or 0");
                    Vector<Long> vector2 = new Vector<Long>();
                    Vector<Short> vector3 = new Vector<Short>();
                    Vector vector4 = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    block3: while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        Trace.trace(TRACE_MASKD, "-- identifyList key found, <" + string3 + ">");
                        vector4 = (Vector)hashtable.get(string3);
                        String string4 = (String)vector4.elementAt(0);
                        Long l = new Long(string3);
                        Trace.trace(TRACE_MASKF, "-- locCode is <" + string4 + ">, slot index is <" + l + ">");
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            String string5 = (String)vector.elementAt(n2);
                            Trace.trace(TRACE_MASKD, "-- location to compare with is <" + string5 + ">");
                            if (string4 != null && string4.compareTo(string5) == 0) {
                                Trace.trace(TRACE_MASKF, "-- adding slotIndex to input array");
                                vector2.addElement(l);
                                vector3.addElement(s);
                                continue block3;
                            }
                            ++n2;
                        }
                    }
                    if (vector2.size() > 0) {
                        hSCCECClient.setIdentifyState(vector2, vector3);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- identifyList is null or identifyList.size() = 0");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- Identify is not supported for this MTMS, <" + string + ">");
            }
        }
        catch (HSCException hSCException) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetIdentifyLEDState() internal exception: " + hSCException);
            new AusMicrocodeLog(_logInfo, 36, hSCException).writeEntry(null);
            throw new Exception("Identify");
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetIdentifyLEDState() general exception: " + throwable);
            new AusMicrocodeLog(_logInfo, 37, throwable).writeEntry(null);
            throw new Exception("Identify");
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.SetIdentifyLEDState()");
        return "Identify";
    }

    public static Vector FetchSwitchList() throws Throwable {
        Vector<SwitchObjectInfo> vector;
        block8: {
            vector = new Vector<SwitchObjectInfo>();
            EExecResult eExecResult = null;
            EExecResult eExecResult2 = null;
            Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchSwitchList()");
            try {
                String string = "/opt/hsc/bin/i_stub_FS dump -n";
                Trace.trace(TRACE_MASKT, "-- about to issue cmd <" + string + ">");
                eExecResult = EExec.Exec((String)string);
                if (eExecResult.rc == 0) {
                    Trace.trace(TRACE_MASKF, "-- 1st cmd (i_stub_FS) request successful");
                    Trace.trace(TRACE_MASKF, "-- data returned is <" + eExecResult.stdout + ">");
                    if (eExecResult.stdout != null) {
                        StringReader stringReader = new StringReader(eExecResult.stdout.trim());
                        BufferedReader bufferedReader = new BufferedReader(stringReader);
                        String string2 = null;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            Trace.trace(TRACE_MASKF, "-- stdout line read is <" + string2 + ">");
                            StringTokenizer stringTokenizer = new StringTokenizer(string2.trim());
                            String string3 = stringTokenizer.nextToken();
                            String string4 = "/opt/hsc/bin/vpdfs -y switch -n " + string3;
                            Trace.trace(TRACE_MASKT, "-- about to issue cmd <" + string4 + ">");
                            eExecResult2 = EExec.Exec((String)string4);
                            if (eExecResult2.rc == 0) {
                                Trace.trace(TRACE_MASKF, "-- 2nd cmd (vpdfs) request successful");
                                Trace.trace(TRACE_MASKF, "-- data returned is <" + eExecResult2.stdout + ">");
                                if (eExecResult2.stdout != null) {
                                    StringReader stringReader2 = new StringReader(eExecResult2.stdout.trim());
                                    BufferedReader bufferedReader2 = new BufferedReader(stringReader2);
                                    String string5 = null;
                                    while ((string5 = bufferedReader2.readLine()) != null) {
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(string5.trim());
                                        String string6 = stringTokenizer2.nextToken();
                                        String string7 = stringTokenizer2.nextToken();
                                        String string8 = stringTokenizer2.nextToken();
                                        Trace.trace(TRACE_MASKD, "-- returned data is => frame:" + string6 + ", cage:" + string7 + ", MTMS:" + string8);
                                        SwitchObjectInfo switchObjectInfo = new SwitchObjectInfo(string6, string7, string8);
                                        vector.addElement(switchObjectInfo);
                                    }
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "-- <" + string4 + "> cmd worked, but returned data is null");
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "-- 2nd cmd (vpdfs) request failed, rc = " + eExecResult2.rc);
                            Trace.trace(TRACE_MASKF, "-- 2nd cmd execResult2.stderr is <" + eExecResult2.stderr.trim() + ">");
                        }
                        break block8;
                    }
                    Trace.trace(TRACE_MASKF, "-- <" + string + "> cmd worked, but returned data is null");
                    break block8;
                }
                Trace.trace(TRACE_MASKF, "-- 1st cmd (i_stub_FS) request failed, rc = " + eExecResult.rc);
                Trace.trace(TRACE_MASKF, "-- 1st cmd execResult.stderr is <" + eExecResult.stderr.trim() + ">");
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "-- HardwareServiceFunctions.FetchSwitchList() exception is " + exception);
            }
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchSwitchList()");
        return vector;
    }

    public static String FetchSwitchSysAttnLEDState(String string, String string2) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchSwitchSysAttnLedState()");
        Trace.trace(TRACE_MASKF, "-- input frame is <" + string + ">, input cage is <" + string2 + ">");
        EExecResult eExecResult = null;
        String string3 = LED_STATE_UNSUPPORTED;
        try {
            String string4 = "/opt/hsc/bin/i_stub_FS led -C IsSystemAttentionSupported -f " + string + " -c " + string2;
            Trace.trace(TRACE_MASKF, "-- about to issue 1st 'i_stub_FS' cmd <" + string4 + ">...");
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc == 0) {
                Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                Trace.trace(TRACE_MASKF, "-- Switch SysAttn LED is supported, continuing...");
                string4 = "/opt/hsc/bin/i_stub_FS led -C GetSystemAttentionList -f " + string + " -c " + string2;
                Trace.trace(TRACE_MASKT, "-- about to issue 2nd 'i_stub_FS' cmd <" + string4 + ">...");
                eExecResult = EExec.Exec((String)string4);
                if (eExecResult.rc == 0) {
                    Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                    if (eExecResult.stdout != null && eExecResult.stdout.length() > 0) {
                        String string5 = eExecResult.stdout.trim();
                        Trace.trace(TRACE_MASKF, "-- return data is not null. It is <" + string5 + ">");
                        if (string5.indexOf(":") != -1 && string5.substring(0, 1).equals("0")) {
                            string4 = "/opt/hsc/bin/i_stub_FS led -C GetSystemAttentionState -f " + string + " -c " + string2;
                            Trace.trace(TRACE_MASKT, "-- about to issue 3rd 'i_stub_FS' cmd <" + string4 + ">...");
                            eExecResult = EExec.Exec((String)string4);
                            if (eExecResult.rc == 0) {
                                if (eExecResult.stdout != null && eExecResult.stdout.length() > 0) {
                                    String string6 = eExecResult.stdout.trim();
                                    Trace.trace(TRACE_MASKF, "switch attn state is <" + string6 + ">");
                                    if (string6.indexOf(":") != -1 && string6.substring(0, 1).equals("0")) {
                                        String string7 = string6.substring(2);
                                        string3 = string7.equals("1") ? LED_STATE_ON : (string7.equals("0") ? LED_STATE_OFF : LED_STATE_UNSUPPORTED);
                                    } else {
                                        Trace.trace(TRACE_MASKF, "invalid or erroneous return data from 3rd i_stub_FS cmd.");
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "switch attn state returned null data");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "-- 3rd 'i_stub_FS' cmd <" + string4 + ") failed, rc = " + eExecResult.rc);
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "-- invalid or erroneous return value from 2nd i_stub_FS cmd.");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "-- no data returned from cmd <" + string4 + ">");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- 2nd 'i_stub_FS' cmd <" + string4 + ") failed, rc = " + eExecResult.rc);
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- Switch System Attention is not supported for this frame/cage");
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchSwitchSysAttnLedState() general exception: " + exception);
            new AusMicrocodeLog(_logInfo, 37, exception).writeEntry(null);
        }
        Trace.trace(TRACE_MASKF, "-- return state is <" + string3 + ">");
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchSwitchSysAttnLedState()");
        return string3;
    }

    public static Vector FetchSwitchFRUIdentifyList(SwitchObjectInfo switchObjectInfo) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchSwitchFRUIdentifyList()");
        Vector<String> vector = new Vector<String>();
        EExecResult eExecResult = null;
        String string = switchObjectInfo.getFrame();
        String string2 = switchObjectInfo.getCage();
        try {
            String string3 = "/opt/hsc/bin/i_stub_FS led -C IsIdentifySupported -f " + string + " -c " + string2;
            Trace.trace(TRACE_MASKF, "-- about to issue 1st 'i_stub_FS' cmd <" + string3 + ">...");
            eExecResult = EExec.Exec((String)string3);
            if (eExecResult.rc == 0) {
                String string4 = eExecResult.stdout.trim();
                Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' return data is not null. It is <" + string4 + ">");
                Trace.trace(TRACE_MASKF, "-- Switch Identify LED is supported, continuing...");
                if (string4.indexOf(":") != -1 && string4.substring(0, 1).equals("0") && !string4.substring(2).equals("0")) {
                    Object object;
                    String string5 = new String("1");
                    int n = 0;
                    boolean bl = true;
                    boolean bl2 = false;
                    String string6 = new String();
                    while (!bl2) {
                        string3 = "/opt/hsc/bin/i_stub_FS led -C GetIdentifyList -f " + string + " -c " + string2 + " -R " + string5;
                        Trace.trace(TRACE_MASKF, "-- about to issue 2nd 'i_stub_FS' cmd <" + string3 + ">...");
                        eExecResult = EExec.Exec((String)string3);
                        Trace.trace(TRACE_MASKF, "-- 2nd 'i_stub_FS' cmd worked, continuing with further analysis of return data...");
                        if (eExecResult.stdout != null && eExecResult.stdout.length() > 0) {
                            Object object2;
                            object = eExecResult.stdout.trim();
                            Trace.trace(TRACE_MASKF, "-- data returned is <" + (String)object + ">");
                            if (!((String)object).endsWith(":")) {
                                if (bl) {
                                    object2 = ((String)object).substring(0, 1);
                                    Integer n2 = new Integer((String)object2);
                                    n = n2 + 1;
                                    bl = false;
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "-- invalid or erroneous return value from 2nd i_stub_FS cmd.");
                                Trace.trace(TRACE_MASKF, "-- Switch Identify (0) not supported for this frame/cage: <" + string + "/" + string2 + ">");
                                break;
                            }
                            Trace.trace(TRACE_MASKF, "-- new ring_select value is <" + string5 + ">");
                            object2 = ((String)object).substring(2);
                            Trace.trace(TRACE_MASKF, "-- loc_data is <" + (String)object2 + ">");
                            string6 = string6 + (String)object2;
                            Trace.trace(TRACE_MASKF, "-- loc_code is now <" + string6 + ">");
                            object2 = new Integer(string5);
                            int n3 = (Integer)object2 + 1;
                            string5 = new Integer(n3).toString();
                            if (n3 <= n) continue;
                            bl2 = true;
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "-- Return data from GetIdentifyList cmd is null or 0 length");
                        throw new Exception("Return data from GetIdentifyList cmd is null or 0 length");
                    }
                    Trace.trace(TRACE_MASKF, "-- full switch location codes returned are: <" + string6 + ">");
                    object = new StringTokenizer(string6, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        vector.addElement(((StringTokenizer)object).nextToken());
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- invalid or erroneous return value from i_stub_FS cmd.");
                    Trace.trace(TRACE_MASKF, "-- Switch Identify (1) not supported for this frame/cage: <" + string + "/" + string2 + ">");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- Switch Identify (2) is not supported for this frame/cage: <" + string + "/" + string2 + ">");
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchSwitchFRUIdentifyList() exception: " + exception);
            new AusMicrocodeLog(_logInfo, 33, exception).writeEntry(null);
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchSwitchFRUIdentifyList()");
        return vector;
    }

    public static Vector FetchSwitchFRUIdentifyLEDState(SwitchObjectInfo switchObjectInfo, Vector vector) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchFRUIdentifyLEDState()");
        Vector<String> vector2 = new Vector<String>();
        EExecResult eExecResult = null;
        String string = switchObjectInfo.getFrame();
        String string2 = switchObjectInfo.getCage();
        try {
            int n = 0;
            while (n < vector.size()) {
                String string3 = null;
                String string4 = (String)vector.elementAt(n);
                if (string4.startsWith("U7045-")) {
                    string3 = string4;
                    string4 = "DRAWER";
                }
                String string5 = "/opt/hsc/bin/i_stub_FS led -C GetIdentifyState -f " + string + " -c " + string2 + " -L " + string4;
                if (string3 != null) {
                    string4 = string3;
                }
                Trace.trace(TRACE_MASKF, "-- about to issue 1st 'i_stub_FS' cmd <" + string5 + ">...");
                eExecResult = EExec.Exec((String)string5);
                String string6 = null;
                String string7 = null;
                if (eExecResult.rc == 0) {
                    string6 = eExecResult.stdout.trim();
                    Trace.trace(TRACE_MASKF, "-- LED state for loc code <" + string4 + "> is <" + string6 + ">");
                    if (string6 != null && string6.length() > 2) {
                        string7 = string6.substring(2);
                        vector2.addElement(string7);
                    } else {
                        string7 = new String("2");
                        vector2.addElement(string7);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- Error determining the LED state for loc code <" + string4 + ">");
                    string7 = new String("2");
                    vector2.addElement(string7);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchSwitchFRUIdentifyLEDState() exception: " + exception);
            new AusMicrocodeLog(_logInfo, 33, exception).writeEntry(null);
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchSwitchFRUIdentifyLEDState()");
        return vector2;
    }

    public static String SetSwitchSystemAttnState(LEDInfoState lEDInfoState) throws Exception {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.SetSwitchSystemAttnState()");
        Integer n = lEDInfoState.getState();
        String string = lEDInfoState.getFrame();
        String string2 = lEDInfoState.getCage();
        String string3 = n.toString();
        Trace.trace(TRACE_MASKF, "-- Switch LED state to set is <" + string3 + ">");
        EExecResult eExecResult = null;
        try {
            String string4 = "/opt/hsc/bin/i_stub_FS led -C IsSystemAttentionSupported -f " + string + " -c " + string2;
            Trace.trace(TRACE_MASKF, "-- about to issue 1st 'i_stub_FS' cmd <" + string4 + ">...");
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc == 0) {
                Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                Trace.trace(TRACE_MASKF, "-- Switch SysAttn LED is supported, continuing...");
                string4 = "/opt/hsc/bin/i_stub_FS led -C SetSystemAttentionState -f " + string + " -c " + string2 + " -S " + string3;
                Trace.trace(TRACE_MASKT, "-- about to issue 2nd 'i_stub_FS' cmd <" + string4 + ">...");
                eExecResult = EExec.Exec((String)string4);
                if (eExecResult.rc == 0) {
                    Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                } else {
                    Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was NOT successful. rc = " + eExecResult.rc);
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- System Attention is not supported for this switch frame/cage");
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetSwitchSystemAttnState() general exception: " + exception);
            new AusMicrocodeLog(_logInfo, 37, exception).writeEntry(null);
            throw new Exception("SwitchSysAttn");
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.SetSwitchSystemAttnState()");
        return "SwitchSysAttn";
    }

    public static String SetSwitchIdentifyLEDState(LEDInfoState lEDInfoState) throws Exception {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.SetSwitchIdentifyLEDState()");
        Integer n = lEDInfoState.getState();
        String string = lEDInfoState.getFrame();
        String string2 = lEDInfoState.getCage();
        Vector vector = lEDInfoState.getLocCodes();
        EExecResult eExecResult = null;
        String string3 = n.toString();
        try {
            String string4 = "/opt/hsc/bin/i_stub_FS led -C IsIdentifySupported -f " + string + " -c " + string2;
            Trace.trace(TRACE_MASKF, "-- about to issue 1st 'i_stub_FS' cmd <" + string4 + ">...");
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc == 0) {
                Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                Trace.trace(TRACE_MASKF, "-- Switch Identify LED is supported, continuing...");
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string5 = null;
                    String string6 = (String)vector.elementAt(n2);
                    if (string6.startsWith("U7045-")) {
                        string5 = string6;
                        string6 = "DRAWER";
                    }
                    string4 = "/opt/hsc/bin/i_stub_FS led -C SetIdentifyState -f " + string + " -c " + string2 + " -L " + string6 + " -S " + string3;
                    if (string5 != null) {
                        string6 = string5;
                    }
                    Trace.trace(TRACE_MASKT, "-- about to issue 2nd 'i_stub_FS' cmd <" + string4 + ">...");
                    eExecResult = EExec.Exec((String)string4);
                    if (eExecResult.rc == 0) {
                        Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was successful");
                    } else {
                        Trace.trace(TRACE_MASKF, "-- 'i_stub_FS' cmd <" + string4 + "> was NOT successful. rc = " + eExecResult.rc);
                    }
                    ++n2;
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- Identify is not supported for this switch frame/cage");
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.SetSwitchIdentifyLEDState() general exception: " + exception);
            new AusMicrocodeLog(_logInfo, 37, exception).writeEntry(null);
            throw new Exception("SwitchIdentify");
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.SetSwitchIdentifyLEDState()");
        return "SwitchIdentify";
    }

    public static String FetchFrameCageInfo(String string) throws Exception {
        Trace.trace(TRACE_MASKT, "-> HardwareServiceFunctions.FetchFrameCageInfo()");
        String string2 = null;
        EExecResult eExecResult = null;
        try {
            String string3 = "/opt/hsc/bin/vpdfs -y switch -m " + string;
            Trace.trace(TRACE_MASKF, "-- about to issue 'vpdfs' cmd <" + string3 + ">...");
            eExecResult = EExec.Exec((String)string3);
            if (eExecResult.rc == 0) {
                string2 = eExecResult.stdout;
                Trace.trace(TRACE_MASKF, "-- 'vpdfs' cmd <" + string3 + "> was successful");
                Trace.trace(TRACE_MASKF, "-- ' return data is <" + string2 + ">");
            } else {
                Trace.trace(TRACE_MASKF, "-- 'vpdfs' cmd failed, rc = " + eExecResult.rc);
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "HardwareServiceFunctions.FetchFrameCageInfo() general exception: " + exception);
            new AusMicrocodeLog(_logInfo, 38, exception).writeEntry(null);
            throw new Exception("vpdfs cmd failed");
        }
        Trace.trace(TRACE_MASKT, "<- HardwareServiceFunctions.FetchFrameCageInfo()");
        return string2;
    }
}

